﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using Microsoft.Xna.Framework;

using GE.Visualisation;

namespace GE.Gui
{
    /// <summary>
    /// An image widget.
    /// </summary>
    class WImage : Widget
    {
        /// <summary>
        /// Image filename.
        /// </summary>
        private string m_assetName;

        /// <summary>
        /// Image graphic ID.
        /// </summary>
        private int m_gid;

        /// <summary>
        /// Position.
        /// </summary>
        private Vector2 m_position;

        /// <summary>
        /// Scale.
        /// </summary>
        private Vector2 m_scale;

        /// <summary>
        /// Center.
        /// </summary>
        private Vector2 m_center;

        /// <summary>
        /// Image filename.
        /// Will reload the asset.
        /// </summary>
        public string AssetName
        {
            set
            {
                reload(value);
            }
        }

        /// <summary>
        /// Position.
        /// </summary>
        public Vector2 Position
        {
            get
            {
                return m_position;
            }
            set
            {
                m_position = value;
            }
        }

        /// <summary>
        /// Scale.
        /// </summary>
        public float Scale
        {
            set
            {
                m_scale = new Vector2(value);
            }
        }

        /// <summary>
        /// Constructor.
        /// </summary>
        /// <param name="assetName">image filemane</param>
        /// <param name="position">position</param>
        public WImage(string assetName, Vector2 position)
        {
            m_position = position;
            m_scale = new Vector2(1f);
            m_center = Vector2.Zero;
            reload(assetName);
        }

        /// <summary>
        /// Reload the image.
        /// </summary>
        /// <param name="assetName">image filename</param>
        private void reload(string assetName)
        {
            m_assetName = assetName;
            m_gid = Gui.Instance.loadTexture(assetName);
            return;
        }

        /// <summary>
        /// Render the widget.
        /// </summary>
        /// <param name="offset">position offset.</param>
        public override void render(Vector2 offset)
        {
            base.render(offset);
            Visu.Instance.displayTexture(m_gid, offset + m_position, m_center, 0f, m_scale);
        }
    }
}
